# -*- coding: utf-8 -*-
"""
    Catch-up TV & More
    Copyright (C) 2017  SylvainCecchetto

    This file is part of Catch-up TV & More.

    Catch-up TV & More is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Catch-up TV & More is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with Catch-up TV & More; if not, write to the Free Software Foundation,
    Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
"""

# The unicode_literals import only has
# an effect on Python 2.
# It makes string literals as unicode like in Python 3
from __future__ import unicode_literals

from codequick import Route, Resolver, Listitem, utils, Script

from resources.lib.labels import LABELS
from resources.lib import web_utils
from resources.lib import resolver_proxy

from bs4 import BeautifulSoup as bs

import re
import urlquick

 # TODO
 # Add Info Date

URL_ROOT = 'http://tele-mag.tv'

URL_EMISSIONS = URL_ROOT + '/emission/emissions'


def replay_entry(plugin, item_id):
    """
    First executed function after replay_bridge
    """
    return list_programs(plugin, item_id)


@Route.register
def list_programs(plugin, item_id):
    """
    Build categories listing
    - Tous les programmes
    - Séries
    - Informations
    - ...
    """
    resp = urlquick.get(URL_EMISSIONS)
    root_soup = bs(resp.text, 'html.parser')
    list_programs_datas = root_soup.find(
        'section', class_='bloc1 emission_dispo').find_all('li')
    for program_datas in list_programs_datas:
        program_title = program_datas.find('a').text
        program_url = program_datas.find(
            'a').get('href')

        item = Listitem()
        item.label = program_title
        item.set_callback(
            list_videos,
            item_id=item_id,
            program_url=program_url)
        yield item


@Route.register
def list_videos(plugin, item_id, program_url):

    resp = urlquick.get(program_url)
    root_soup = bs(resp.text, 'html.parser')
    list_videos_datas = root_soup.find_all(
        'div', class_='bloc1_element_listeVideo')

    for video_datas in list_videos_datas:
        video_title = video_datas.find('a').get('title')
        video_image = URL_ROOT + video_datas.find('img').get('src')
        video_url = video_datas.find('a').get('href')

        item = Listitem()
        item.label = video_title
        item.art['thumb'] = video_image

        item.context.script(
            get_video_url,
            plugin.localize(LABELS['Download']),
            item_id=item_id,
            video_url=video_url,
            video_label=LABELS[item_id] + ' - ' + item.label,
            download_mode=True)

        item.set_callback(
            get_video_url,
            item_id=item_id,
            video_url=video_url)
        yield item


@Resolver.register
def get_video_url(
        plugin, item_id, video_url, download_mode=False, video_label=None):

    resp = urlquick.get(
        video_url,
        headers={'User-Agent': web_utils.get_random_ua},
        max_age=-1)
    root_soup = bs(resp.text, 'html.parser')
    stream_url = root_soup.find(
        id='main_video').get('src')
    if 'player.vimeo.com' in stream_url:
        video_id = re.compile(
            r'player.vimeo.com\/video/(.*?)\?').findall(stream_url)[0]
        return resolver_proxy.get_stream_vimeo(
            plugin, video_id, download_mode, video_label)
    else:
        # TODO if new video hoster
        return False

def live_entry(plugin, item_id, item_dict):
    return get_live_url(plugin, item_id, item_id.upper(), item_dict)


@Resolver.register
def get_live_url(plugin, item_id, video_id, item_dict):

    resp = urlquick.get(URL_ROOT)
    root_soup = bs(resp.text, 'html.parser')
    live_datas = root_soup.find('iframe')
    live_html = urlquick.get(live_datas.get('src'))
    live_id = re.compile(
        r'www.youtube.com\/watch\?v=(.*?)\"').findall(live_html.text)[0]
    return resolver_proxy.get_stream_youtube(plugin, live_id, False)
