# -*- coding: utf-8 -*-
"""
    Catch-up TV & More
    Copyright (C) 2017  SylvainCecchetto

    This file is part of Catch-up TV & More.

    Catch-up TV & More is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Catch-up TV & More is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with Catch-up TV & More; if not, write to the Free Software Foundation,
    Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
"""

# The unicode_literals import only has
# an effect on Python 2.
# It makes string literals as unicode like in Python 3
from __future__ import unicode_literals

from codequick import Route, Resolver, Listitem, utils, Script

from resources.lib.labels import LABELS
from resources.lib import web_utils
from resources.lib import download

import datetime
import json
import re
import urlquick


# TO DO and Infos
# RTR No category (verify in the future ?)
# Add More Video_button (for category and emissions)
# Add Info Video
# Add Quality Mode / test Download Mode


URL_ROOT = 'https://%s.%s.ch'
# (www or play), channel_name

# Replay
URL_CATEGORIES_JSON = 'https://%s.%s.ch/play/v2/tv/topicList?layout=json'
# (www or play), channel_name

URL_EMISSIONS = 'https://www.%s.ch/play/tv/%s?index=all'
# channel_name, name_emission

URL_LIST_EPISODES = 'https://www.%s.ch/play/v2/tv/show/%s/' \
                    'latestEpisodes?numberOfEpisodes=50' \
                    '&tillMonth=%s&layout=json'
# channel_name, IdEmission, ThisMonth (11-2017)

# Live
URL_LIVE_JSON = 'http://www.%s.ch/play/v2/tv/live/overview?layout=json'
# channel_name

URL_TOKEN = 'https://tp.srgssr.ch/akahd/token?acl=%s'
# acl

URL_INFO_VIDEO = 'https://il.srgssr.ch/integrationlayer' \
                 '/2.0/%s/mediaComposition/video/%s.json' \
                 '?onlyChapters=true&vector=portalplay'
# channel_name, video_id

EMISSIONS_NAME = {
    'rts': 'emissions',
    'rsi': 'programmi',
    'rtr': 'emissiuns',
    'srf': 'sendungen'
}

LIVE_LIVE_CHANNEL_NAME = {
    "rtsun": "RTS Un",
    "rtsdeux": "RTS Deux",
    "rtsinfo": "RTS Info",
    "rtscouleur3": "RTS Couleur 3",
    "rsila1": "RSI La 1",
    "rsila2": "RSI La 2",
    "srf1": "SRF 1",
    "srfinfo": "SRF Info",
    "srfzwei": "SRF Zwei",
    "rtraufsrf1": "RTR auf SRF 1",
    "rtraufsrfinfo": "RTR auf SRF Info",
    "rtraufsrf2": "RTR auf SRF 2"
}


def replay_entry(plugin, item_id):
    """
    First executed function after replay_bridge
    """
    return list_categories(plugin, item_id)


@Route.register
def list_categories(plugin, item_id):
    """
    Build categories listing
    - Tous les programmes
    - Séries
    - Informations
    - ...
    """
    if 'swissinfo' not in item_id:
        category_title = EMISSIONS_NAME[item_id]
        category_url = URL_EMISSIONS % (item_id, EMISSIONS_NAME[item_id])

        item = Listitem()
        item.label = category_title
        item.set_callback(
            list_programs,
            item_id=item_id,
            category_url=category_url)
        yield item

    if 'swissinfo' in item_id:
        first_part_fqdn = 'play'
    else:
        first_part_fqdn = 'www'

    resp = urlquick.get(URL_CATEGORIES_JSON % (first_part_fqdn, item_id))
    json_parser = json.loads(resp.text)

    for category_datas in json_parser:
        category_title = category_datas["title"]
        category_url = URL_ROOT % (first_part_fqdn, item_id) + \
            category_datas["latestModuleUrl"]

        item = Listitem()
        item.label = category_title
        item.set_callback(
            list_videos_category,
            item_id=item_id,
            category_url=category_url)
        yield item


@Route.register
def list_programs(plugin, item_id, category_url):
    """
    Build programs listing
    - Les feux de l'amour
    - ...
    """
    resp = urlquick.get(category_url)
    json_value = re.compile(
        r'data-alphabetical-sections=\\\"(.*?)\\\"').findall(
            resp.text)[0]
    json_value = json_value.replace('&quot;', '"')
    json_value = json_value.replace('\\\\"', ' ')
    json_parser = json.loads(json_value)
    for list_letter in json_parser:
        for program_datas in list_letter["showTeaserList"]:
            program_title = program_datas["title"]
            if 'rts.ch' in program_datas["imageUrl"]:
                program_image = program_datas["imageUrl"] + \
                    '/scale/width/448'
            else:
                program_image = program_datas["imageUrl"]
            program_id = program_datas["id"]

            item = Listitem()
            item.label = program_title
            item.art['thumb'] = program_image
            item.set_callback(
                list_videos_program,
                item_id=item_id,
                program_id=program_id)
            yield item


@Route.register
def list_videos_category(plugin, item_id, category_url):

    resp = urlquick.get(category_url)
    json_value = re.compile(
        r'data-teaser=\"(.*?)\"').findall(resp.text)[0]
    json_value = json_value.replace('&quot;', '"')
    json_parser = json.loads(json_value)

    for video_datas in json_parser:
        video_title = ''
        if 'showTitle' in video_datas:
            video_title = video_datas["showTitle"] + \
                ' - ' + video_datas["title"]
        else:
            video_title = video_datas["title"]
        video_plot = ''
        if 'description' in video_datas:
            video_plot = video_datas["description"]
        video_image = video_datas["imageUrl"] + '/scale/width/448'
        video_url = video_datas["absoluteDetailUrl"]

        item = Listitem()
        item.label = video_title
        item.art['thumb'] = video_image
        item.info['plot'] = video_plot

        item.context.script(
            get_video_url,
            plugin.localize(LABELS['Download']),
            item_id=item_id,
            video_url=video_url,
            video_label=LABELS[item_id] + ' - ' + item.label,
            download_mode=True)

        item.set_callback(
            get_video_url,
            item_id=item_id,
            video_url=video_url)
        yield item


@Route.register
def list_videos_program(plugin, item_id, program_id):

    date = datetime.datetime.now()
    actual_month = str(date).split(' ')[0].split('-')[1] + '-' + \
        str(date).split(' ')[0].split('-')[0]

    resp = urlquick.get(URL_LIST_EPISODES % (item_id, program_id, actual_month))
    json_parser = json.loads(resp.text)

    for video_datas in json_parser["episodes"]:
        video_title = ''
        if 'showTitle' in video_datas:
            video_title = video_datas["showTitle"] + \
                ' - ' + video_datas["title"]
        else:
            video_title = video_datas["title"]
        video_plot = ''
        if 'description' in video_datas:
            video_plot = video_datas["description"]
        video_image = video_datas["imageUrl"] + '/scale/width/448'
        video_url = video_datas["absoluteDetailUrl"]

        item = Listitem()
        item.label = video_title
        item.art['thumb'] = video_image
        item.info['plot'] = video_plot

        item.context.script(
            get_video_url,
            plugin.localize(LABELS['Download']),
            item_id=item_id,
            video_url=video_url,
            video_label=LABELS[item_id] + ' - ' + item.label,
            download_mode=True)

        item.set_callback(
            get_video_url,
            item_id=item_id,
            video_url=video_url)
        yield item


@Resolver.register
def get_video_url(
        plugin, item_id, video_url, download_mode=False, video_label=None):

    video_id = video_url.split('=')[1]
    if item_id == 'swissinfo':
        channel_name_value = 'swi'
    else:
        channel_name_value = item_id
    resp = urlquick.get(URL_INFO_VIDEO % (channel_name_value, video_id))
    json_parser = json.loads(resp.text)

    # build url
    stream_url = ''
    for stream_datas in json_parser["chapterList"]:
        if video_id in stream_datas["id"]:
            for stream_datas_url in stream_datas["resourceList"]:
                if 'HD' in stream_datas_url["quality"] and \
                    'mpegURL' in stream_datas_url["mimeType"]:
                    stream_url = stream_datas_url["url"]
                    break
                else:
                    if 'mpegURL' in stream_datas_url["mimeType"]:
                        stream_url = stream_datas_url["url"]
    acl_value = '/i/%s/*' % (re.compile(
        r'\/i\/(.*?)\/').findall(stream_url)[0])
    token_datas = urlquick.get(URL_TOKEN % acl_value)
    token_jsonparser = json.loads(token_datas.text)
    token = token_jsonparser["token"]["authparams"]

    final_video_url = stream_url + '?' + token

    if download_mode:
        return download.download_video(final_video_url, video_label)
    return final_video_url


def live_entry(plugin, item_id, item_dict):
    return get_live_url(plugin, item_id, item_id.upper(), item_dict)


@Resolver.register
def get_live_url(plugin, item_id, video_id, item_dict):

    resp = urlquick.get(URL_LIVE_JSON % item_id[:3])
    json_parser = json.loads(resp.text)
    live_id = ''
    for live_datas in json_parser["teaser"]:
        if live_datas["channelName"] in LIVE_LIVE_CHANNEL_NAME[item_id]:
            live_id = live_datas["id"]
    if live_id is None:
        # Add Notification
        return False
    resp2 = urlquick.get(URL_INFO_VIDEO % (item_id[:3], live_id))
    json_parser2 = json.loads(resp2.text)

    # build stream_url
    stream_url = ''
    for stream_datas in json_parser2["chapterList"]:
        if live_id in stream_datas["id"]:
            for stream_datas_url in stream_datas["resourceList"]:
                if 'HD' in stream_datas_url["quality"] and \
                        'mpegURL' in stream_datas_url["mimeType"]:
                    stream_url = stream_datas_url["url"]
                    break
                else:
                    if 'mpegURL' in stream_datas_url["mimeType"]:
                        stream_url = stream_datas_url["url"]

    acl_value = '/i/%s/*' % (re.compile(
        r'\/i\/(.*?)\/').findall(stream_url)[0])
    token_datas = urlquick.get(URL_TOKEN % acl_value)
    token_jsonparser = json.loads(token_datas.text)
    token = token_jsonparser["token"]["authparams"]
    return stream_url + '?' + token
